/****** Object:  StoredProcedure [dbo].[P_EST_PROD_CPL_MEDIAP_MANUTENCAO]    Script Date: 12/16/2013 10:52:22 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_MEDIAP_MANUTENCAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_MEDIAP_MANUTENCAO]
GO

/****** Object:  StoredProcedure [dbo].[P_EST_PROD_CPL_MEDIAP_MANUTENCAO]    Script Date: 12/16/2013 10:52:22 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
--EXEC P_EST_PROD_CPL_MEDIAP_MANUTENCAO 1,9,45228,2,1,3
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_MEDIAP_MANUTENCAO] (@CD_EMP INT,
												   @CD_FILIAL INT,
												   @CD_PROD INT,
												   @QT_MEDIAP MONEY,
												   @CD_USU INT,
												   @CD_ARV_MERC_LINHA INT,
												   @CD_PROD_ORIGEM INT=0)
WITH ENCRYPTION AS
SET NOCOUNT ON;
begin
DECLARE @CD_SIGLA INT
DECLARE @DT_CAD DATETIME
SET @DT_CAD=CONVERT(CHAR(10),GETDATE(),112)
	--Gerando nova silga
	SET @CD_SIGLA = ISNULL((SELECT dbo.UFD_EST_ARV_MD_F_GRP_PARAM_CURVA_AVALIACAO(@CD_EMP,@CD_FILIAL,@QT_MEDIAP,@CD_PROD)),4)

	IF NOT EXISTS(SELECT
				CD_PROD
			  FROM
				EST_PROD_CPL_MEDIAF
			  WHERE
				CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND CD_PROD=@CD_PROD)

	BEGIN
		--Inserindo automaticamente a media F somente jogando a curva padrao
		INSERT INTO EST_PROD_CPL_MEDIAF	
				(CD_EMP, 
				CD_FILIAL, 
				CD_PROD, 
				CD_SIGLA, 
				QTDE_MEDIAF, 
				QTDE_FINANCIADO, 
				QTDE_FACEAMENTO, 
				QTDE_LIMITADOR, 
				VALID_QTDE_FACEAMENTO, 
				QT_VD_ATUAL, 
				QT_VD_MES1, 
				QT_VD_MES2, 
				QT_VD_MES3, 
				LIMITP, 
				LIMITV, 
				CD_USU, 
				DT_CAD, 
				DT_ULT_ALT, 
				SAZ, 
				DT_NASC)
				SELECT 
				i.CD_EMP, 
				i.CD_FILIAL, 
				i.CD_PROD, 
				@CD_SIGLA,
				0 AS QTDE_MEDIAF, 
				0 AS QTDE_FINANCIADO, 
				0 AS QTDE_FACEAMENTO, 
				0 AS QTDE_LIMITADOR, 
				NULL AS VALID_QTDE_FACEAMENTO, 
				0 AS QT_VD_ATUAL, 
				0 AS QT_VD_MES1, 
				0 AS QT_VD_MES2, 
				0 AS QT_VD_MES3, 
				0 AS LIMITP, 
				0 AS LIMITV, 
				1 AS CD_USU, 
				CONVERT(CHAR(10),GETDATE(),112) AS DT_CAD, 
				NULL AS DT_ULT_ALT, 
				0 AS SAZ,
				NULL AS DT_NASC
			FROM
				EST_PROD_CPL i
			WHERE
				CD_EMP =@CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_PROD = @CD_PROD
	END
	ELSE
		BEGIN
			--ZERANDO A MEDIAF
			UPDATE
				EST_PROD_CPL_MEDIAF
			SET 
				QTDE_MEDIAF=0,
				CD_USU=@CD_USU,
				DT_ULT_ALT=@DT_CAD,
				CD_SIGLA=@CD_SIGLA
			WHERE
				CD_EMP =@CD_EMP
				AND CD_FILIAL =@CD_FILIAL
				AND CD_PROD=@CD_PROD 		
		END
    
    --Zerar mediaF do produto origem
    IF @CD_PROD_ORIGEM > 0 
    BEGIN
	   --ZERANDO A MEDIAF ORIGEM
	   UPDATE
		  EST_PROD_CPL_MEDIAF
	   SET 
		  QTDE_MEDIAF=0,
		  CD_USU=@CD_USU,
		  DT_ULT_ALT=@DT_CAD,
		  CD_SIGLA=@CD_SIGLA
	   WHERE
		  CD_EMP =@CD_EMP
		  AND CD_FILIAL =@CD_FILIAL
		  AND CD_PROD=@CD_PROD_ORIGEM 	
		  
		  
	   --ZERANDO A MEDIAp ORIGEM
	   UPDATE
		  EST_PROD_CPL_MEDIAP
	   SET 
		  QTDE_MEDIAP=0,
		  CD_USU=@CD_USU,
		  DT_ULT_ALT=@DT_CAD 
	   WHERE
		  CD_EMP =@CD_EMP
		  AND CD_FILIAL =@CD_FILIAL
		  AND CD_PROD=@CD_PROD_ORIGEM 		
    END

	--Criando a MediaP
	IF NOT EXISTS(SELECT
				CD_PROD
			  FROM
				EST_PROD_CPL_MEDIAP
			  WHERE
				CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND CD_PROD=@CD_PROD)

	begin 
		INSERT INTO
			EST_PROD_CPL_MEDIAP 
			(CD_EMP,CD_FILIAL,CD_PROD,QTDE_MEDIAP,CD_USU,DT_CAD,DT_ULT_ALT,FALTA_CRONICA)
		VALUES
			(@CD_EMP,@CD_FILIAL,@CD_PROD,@QT_MEDIAP, @CD_USU,@DT_CAD,NULL,0)
	end
	
	UPDATE
		EST_PROD_CPL_MEDIAP
	SET 
		QTDE_MEDIAP=@QT_MEDIAP,
		CD_USU=@CD_USU,
		DT_ULT_ALT=@DT_CAD
	WHERE
		CD_EMP =@CD_EMP
		AND CD_FILIAL =@CD_FILIAL
		AND CD_PROD=@CD_PROD 

	--Deletando o nascimento do produto
	DELETE FROM 
		EST_PROD_CPL_NASC
	WHERE
		CD_EMP =@CD_EMP
		AND CD_FILIAL =@CD_FILIAL
		AND CD_PROD=@CD_PROD 

	--Alterando sigla da EST_PROD_CPL
	UPDATE
		EST_PROD_CPL
	SET 
		EST_PROD_CPL.MEDIAF=@QT_MEDIAP,
		EST_PROD_CPL.CD_SIGLA=@CD_SIGLA,
		EST_PROD_CPL.EMAX= ISNULL(A.EMAX,0), 
		EST_PROD_CPL.ESEG= ISNULL(A.ESEG,0)
	FROM
		EST_PROD_CPL LEFT JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA A ON 
		EST_PROD_CPL.CD_EMP	= A.CD_EMP    AND 
		EST_PROD_CPL.CD_FILIAL = A.CD_FILIAL AND 
		EST_PROD_CPL.CD_PROD	= A.CD_PROD
	WHERE
		EST_PROD_CPL.CD_EMP =@CD_EMP
		AND EST_PROD_CPL.CD_FILIAL =@CD_FILIAL
		AND EST_PROD_CPL.CD_PROD=@CD_PROD 			
		
	--E se tiver estoque nasce o produto com a data da criacao da MediaP
	IF EXISTS(SELECT
				QT_EST
			  FROM
				EST_PROD_CPL
			  WHERE
				CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND CD_PROD=@CD_PROD
				AND QT_EST > 0)
	begin
		INSERT INTO EST_PROD_CPL_NASC
			(CD_EMP, CD_FILIAL, CD_PROD, DT_NASC, MEDIA_F_LIBERADA, QTDE_MES_VENDA_FECHADO)
			VALUES
			(@CD_EMP,@CD_FILIAL,@CD_PROD,@DT_CAD,0,0)
	end	

	--Atualiza grupo de parametros	
	EXECUTE P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC @CD_EMP, @CD_FILIAL, @CD_PROD;

	--esse segundo update é necessário para aplicar os parâmetros no produto para a reposição no mesmo dia
	UPDATE
		EST_PROD_CPL
	SET 
		EST_PROD_CPL.MEDIAF=@QT_MEDIAP,
		EST_PROD_CPL.CD_SIGLA=@CD_SIGLA,
		EST_PROD_CPL.EMAX= ISNULL(A.EMAX,0), 
		EST_PROD_CPL.ESEG= ISNULL(A.ESEG,0)
	FROM
		EST_PROD_CPL LEFT JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA A ON 
		EST_PROD_CPL.CD_EMP	= A.CD_EMP    AND 
		EST_PROD_CPL.CD_FILIAL = A.CD_FILIAL AND 
		EST_PROD_CPL.CD_PROD	= A.CD_PROD
	WHERE
		EST_PROD_CPL.CD_EMP =@CD_EMP
		AND EST_PROD_CPL.CD_FILIAL =@CD_FILIAL
		AND EST_PROD_CPL.CD_PROD=@CD_PROD 	

	

end

GO


